const steps = [
  {
    id: 1,
    title: "ثبت استعلام از مغازه",
    description:
      "نام قطعه، کد فنی یا حتی توضیح ساده را در پنل کمبِر وارد می‌کنید؛ می‌توانید عکس قطعه را هم ضمیمه کنید.",
    meta: "کمتر از ۱۵ ثانیه",
  },
  {
    id: 2,
    title: "ارسال خودکار به تأمین‌کنندگان",
    description:
      "درخواست شما برای شبکه‌ای از تأمین‌کنندگان معتبر ارسال می‌شود و هر کدام قیمت، موجودی و برند پیشنهادی را ثبت می‌کنند.",
    meta: "پاسخ‌گویی هم‌زمان چند تأمین‌کننده",
  },
  {
    id: 3,
    title: "مقایسه و انتخاب بهترین پیشنهاد",
    description:
      "کمبِر پیشنهادها را بر اساس قیمت، سرعت تحویل و اعتبار تأمین‌کننده مرتب می‌کند و شما با یک کلیک سفارش می‌دهید.",
    meta: "بدون تماس تلفنی‌های تکراری",
  },
];

export function HowItWorksSection() {
  return (
    <section
      id="how-it-works"
      className="border-b border-border bg-background py-14 sm:py-16"
    >
      <div className="mx-auto max-w-6xl px-4 sm:px-6 lg:px-8">
        <div className="flex flex-col gap-4 sm:flex-row sm:items-end sm:justify-between">
          <div className="space-y-2">
            <h2 className="text-xl font-semibold text-foreground sm:text-2xl">
              کمبِر چطور کار می‌کند؟
            </h2>
            <p className="max-w-xl text-sm text-muted-foreground">
              از لحظه ثبت استعلام تا تحویل قطعه، کل مسیر دیجیتال و شفاف است؛
              مخصوصاً برای مغازه‌دارهایی که روزانه ده‌ها تماس برای یک قطعه
              می‌گیرند.
            </p>
          </div>
          <p className="text-xs text-muted-foreground">
            تمرکز شما روی مشتری باشد، نه پیدا کردن قطعه.
          </p>
        </div>

        <div className="mt-8 grid gap-4 sm:grid-cols-3">
          {steps.map((step) => (
            <article
              key={step.id}
              className="relative flex flex-col rounded-2xl border border-border bg-white p-4 shadow-[0_14px_40px_rgba(15,23,42,0.08)]"
            >
              <div className="mb-3 inline-flex h-8 w-8 items-center justify-center rounded-xl bg-black text-xs font-semibold text-white">
                {step.id}
              </div>
              <h3 className="text-sm font-semibold text-foreground">
                {step.title}
              </h3>
              <p className="mt-2 text-xs leading-relaxed text-muted-foreground">
                {step.description}
              </p>
              <p className="mt-3 text-[11px] text-neutral-500">{step.meta}</p>
            </article>
          ))}
        </div>
      </div>
    </section>
  );
}

